<?php
/*--------------------------------------------------------------------------------------------------
    ImagePath.php 2020-02-12
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Images\ValueObjects;

/**
 * Class ImagePath
 * @package Gambio\Shop\SellingUnit\ProductInformation\Services\ProductImage\ValueObjects
 */
class ImagePath
{
    /**
     * @var string
     */
    protected $path;
    
    
    /**
     * ImagePath constructor.
     *
     * @param string $path
     */
    public function __construct(string $path)
    {
        $this->path = $path;
    }
    
    
    /**
     * @return string
     */
    public function value(): string
    {
        return $this->path;
    }
}